(function($){

$.fn.routeMap = function(options) {
	var map_wrap = this;
	options.center = options.center.split(',');
	options.center = new google.maps.LatLng(options.center[0], options.center[1]);

	function drawRoute(request, renderer) {
		directionsService.route(request, function(response, status) {
			if (status == google.maps.DirectionsStatus.OK) {
				renderer.setDirections(response);
			}
		});
	}

	var opts = {
        'zoom': options.zoom,
        'center': options.center,
        'mapTypeId': google.maps.MapTypeId.ROADMAP,
        // disableDoubleClickZoom: true,
        'panControl': true,
        'zoomControl': true,
        'mapTypeControl': true,
        'scaleControl': true,
        'streetViewControl': true,
        'overviewMapControl': true
    };
    var map = new google.maps.Map(map_wrap.get(0), opts);
    var overlay = new google.maps.OverlayView();
	overlay.draw = function() {};
	overlay.setMap(map);
	map.custom_overlay = overlay;
	var directionsService = new google.maps.DirectionsService();
	var bounds = new google.maps.LatLngBounds();
	
	for (var i = 0; i < options.routes.length; i++) {
		var route = options.routes[i];
		for (var type in route.pins) {
			var p = route.pins[type];
			route.pins[type].latlng = new google.maps.LatLng(p.geocoords[0], p.geocoords[1]);
			var opts = {
		        'position': route.pins[type].latlng,
		        'map': map,
		        'draggable': false
		    }
		    if (p.pin_image) {
		    	opts.icon = p.pin_image;
		    }

			var marker = new google.maps.Marker(opts);
			marker.route_id = route.ID;
			marker.pin_type = type;
			marker.pin_anchor = p.pin_anchor;

		    google.maps.event.addListener(marker, 'mouseover', function(){
		    	var tooltip = $('.route-pin-' + this.route_id + '-' + this.pin_type + ':first');
		    	tooltip.appendTo("body");
		    	var proj = map.custom_overlay.getProjection();
				var pos = this.getPosition();
				var p = proj.fromLatLngToContainerPixel(pos);

		    	var anchor_x = 0;
		    	var anchor_y = -10;
		    	if (this.getIcon()) {
		    		// anchor_x = Math.ceil(this.pin_anchor[0] / 2);
		    		anchor_y -= this.pin_anchor[1];
		    	} else {
		    		anchor_y -= 40; // default google pin height
		    	}
		    	tooltip.show().css({
		    		top: map_wrap.offset().top + p.y - tooltip.height() + anchor_y,
		    		left: map_wrap.offset().left + p.x - Math.ceil(tooltip.width  () / 2) + anchor_x
		    	});
		    });
		    google.maps.event.addListener(marker, 'mouseout', function(){
		    	$('.route-pin-' + this.route_id + '-' + this.pin_type).hide();
		    });

			bounds.extend(opts.position);
		}
	    var directionsRendererOptions = {
			'hideRouteList': true,
			'suppressInfoWindows': true,
			'preserveViewport': true,
			'suppressMarkers': true,
			'polylineOptions': {
				'strokeWeight': 6,
				'strokeOpacity': 0.6,
				'strokeColor': route.stroke_color
			}
		};
		var directionsRenderer = new google.maps.DirectionsRenderer(directionsRendererOptions);
		directionsRenderer.setMap(map);

		var waypoints = [];
		for (var j = 0; j < route.waypoints.length; j++) {
			var wp = route.waypoints[j];
			waypoints.push({
				'location': new google.maps.LatLng(wp.geocoords[0], wp.geocoords[1])
			});
		};

		var request = {
			'origin': route.pins.origin.latlng,
			'destination': route.pins.destination.latlng,
			'travelMode': google.maps.DirectionsTravelMode.DRIVING
		}
		if (waypoints.length > 0) {
			request.waypoints = waypoints;
		}

		drawRoute(request, directionsRenderer);
	}

	if (options.center_mode == 'auto') {
		map.fitBounds(bounds);
	}
}

})(jQuery);